 aR  w [ mh9      h	 oZ       nSystem-wide$PAGEWIDTH (150)

    NAME TimerBugFix

$INCLUDE (`w`CcProm`Cp.Constant.Asm.Inc~Text~)

CGROUP GROUP CODE

    PUBLIC RepgmSystick
    EXTRN  CpSystemTick:NEAR

CODE SEGMENT PUBLIC 'CODE'
     ASSUME CS:CGROUP

;    RepgmSystick
;
;    This routine will disable systick, reset its values to the values
;    set in Cp.Init and then reenable systick.
;    What if it was disabled at the time ???

timer2Mode   EQU   0FF66H
timer2MaxCnt EQU   0FF62H
timer2Count  EQU   0FF60H

sysTickMode  EQU   0C001H
sysTickCnt   EQU   12500

RepgmSystick PROC NEAR
    PUSH DS
    PUSH BP

    XOR  AX, AX           ; mode = 0 (turn off)
    PUSH AX
    CALL CpSystemTick     ; turn off sysTick intr

    PUSHF                 ; save state of intrs
    CLI                   ; DISABLE

   	MOV  DX, timer2MaxCnt
   	MOV  AX, sysTickCnt   ; set up systick
	   OUT  DX, AX           ; count value

    MOV  DX, timer2Mode
    MOV  AX, sysTickMode  ; set up systick
    OUT  DX, AX           ; mode value

    POPF                  ; restore state of intrs

    XOR  AX, AX
    INC  AX               ; mode = 1 (turn on)
    PUSH AX
    CALL CpSystemTick     ; turn on sysTick intr

    POP  BP
    POP  DS
    RET
RepgmSystick ENDP

CODE ENDS

    END
